#include "CameraCBuffer.hlsli"
#include "MotionBlur.hlsli"

cbuffer ModelConstantBuffer : register(b1)
{
	matrix WorldViewProjectionMatrix;
	matrix PrevWVPMatrix;
	matrix InvWVPMatrix;
	matrix NormalMatrix;
	float3 Emission;
};


struct VSInput
{
	float3 PositionObjS : SV_Position;
	float3 Normal : NORMAL;
	float4 Color : COLOR0;
};

struct VSOutput
{
	float4 PositionClipS : SV_Position;
	float4 Color : COLOR0;
	float4 Normal : NORMAL;
	float2 Velocity : VELOCITY;
};

VSOutput main(VSInput input)
{
	VSOutput output = (VSOutput)0;
	float4 pos = float4(input.PositionObjS, 1.0f);

	// Transform the vertex position into projected space.
	float4 positionClipS = mul(pos, WorldViewProjectionMatrix);

	// Transform the normal.
	float4 norm = float4(input.Normal, 1.0f);
	output.Normal = mul(norm, NormalMatrix);

	// Pass the color through.
	output.Color = input.Color;

	// Calculate the velocity (it will be interpolated between vertices)
	float4 prevPositionClipS = mul(pos, PrevWVPMatrix);
	float2 velocity = CalcVelocity(positionClipS, prevPositionClipS);

	output.PositionClipS = positionClipS;
	output.Velocity = velocity;

	return output;
}
